import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.locatorId) {
    newObjValue = {...newObjValue, 
      M_Locator_ID: {
        id: body.locatorId,
        tableName: 'M_Locator'
      }
    }
  }
  if(body.locatorToId) {
    newObjValue = {...newObjValue, 
      M_LocatorTo_ID: {
        id: body.locatorToId,
        tableName: 'M_Locator'
      }
    }
  }
  if(body.productId) {
    newObjValue = {...newObjValue, 
      M_Product_ID: {
        id: body.productId,
        tableName: 'M_Product'
      }
    }
  }
  if(body.attributeSetInstanceId) {
    newObjValue = {...newObjValue, 
      M_AttributeSetInstance_ID: {
        id: body.attributeSetInstanceId,
        tableName: 'M_AttributeSetInstance'
      }
    }
  }
  if(body.attributeSetInstanceToId) {
    newObjValue = {...newObjValue, 
      M_AttributeSetInstanceTo_ID: {
        id: body.attributeSetInstanceToId,
        tableName: 'M_AttributeSetInstance'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/m_movementline/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      line: body.line,
      description: body.description,
      //value: body.value,
      movementQty: body.movementQty,
      confirmedQty: body.confirmedQty,
      targetQty: body.targetQty,
      scrappedQty: body.scrappedQty,
      //processed: body.processed,
      ...newObjValue,
      tableName: 'm_movementline'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    if(err.status >= 500 || err.statusCode >= 500) {
      data = {
        status: err.status || err.statusCode,
        message: err.detail || err.details || err.message || err.statusMessage
      }
    } else {
    try {
        let authToken: any = await refreshTokenHelper(event)
        data = await handleFunc(event, authToken)
      } catch(error: any) {
        data = {
          status: error.status || error.statusCode || 500,
          message: error.detail || error.details || error.message || error.statusMessage
        }
        forceLogoutHelper(event, data)
      }
    }
  }

  return data
})